// Dark mode

const darkmode = document.querySelector(".darkmode");
const body = document.querySelector("body");
const footer = document.querySelector("footer");
const header = document.querySelector("header");

darkmode.onclick = function(e) {
	e.preventDefault();
	darkmode.classList.toggle("light");	
	const lightmode = darkmode.classList.contains("light");	
	
	if(lightmode == true) {
		body.classList.add("bg-white", "text-dark");
		body.classList.remove("bg-dark", "text-white");
		footer.classList.add("bg-white", "text-dark");
		footer.classList.remove("bg-dark", "text-white");
		header.classList.add("bg-white", "text-dark");
		header.classList.remove("bg-dark", "text-white");
	} else {
		body.classList.add("bg-dark", "text-white");
		body.classList.remove("bg-white", "text-dark");
		footer.classList.add("bg-dark", "text-white");
		footer.classList.remove("bg-white", "text-dark");
		header.classList.add("bg-dark", "text-white");
		header.classList.remove("bg-white", "text-dark");		
	}
	
};

if (window.innerWidth < 1025) {
	
	const mobileContents = document.querySelector(".mobileContents");
	
	mobileContents.prepend(darkmode);
	
}


// Mobile menu

const menuButton = document.querySelector("#triggerMenu");
const nav = document.querySelector("#navbar");
var navButtons = nav.getElementsByClassName("navLink");

menuButton.onclick = function(e) {
	e.preventDefault();
	menuButton.classList.toggle("active");	
	body.classList.toggle("mobileMenu");
};


for(var b = 0; b < navButtons.length; b++) {
	
	var navButton = navButtons[b];
	
	navButton.onclick = function() {
		menuButton.classList.remove("active");	
		body.classList.remove("mobileMenu");
	};
	
}


// Top button

let topButton = document.getElementById("goTop");

window.onscroll = function() {
	scrollFunction()
};

function scrollFunction() {
	
	if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
		topButton.style.opacity = "0.8";
	} else {
		topButton.style.opacity = "0";
	}
}

function goTop() {
	document.body.scrollTop = 0;
	document.documentElement.scrollTop = 0;
}


// Form ajax

function sendInfo() {
	
	var form = $("form#rating");
	var rating = $(".rating input[type='radio']:checked");
	
	setTimeout(function(){
	
		//if($(".rating input[type='radio']:checked").length) {
		if(rating.length && rating.val() > 0) {
		
			$.ajax({
			  type: form.attr("method"),
			  url: form.attr("action"),
			  data: form.serialize(),
			  success: function(data) {
				  form.hide();
				  $("#github").show("slow");
			  }
			});
		
		}
		
	}, 3000);

}

$('#ajaxB').click(function(event) {
	
    event.preventDefault();

	sendInfo();
	
});


// Home text writer

var i = 0;
var txt = 'Web Developor';
var speed = 150;
var title = document.getElementById("bannerTitle");

var u = 0;
var newTxt = "er!";

var o = 0;


function newType() {

	if (u < newTxt.length) {
		
		title.innerHTML += "<span>" + newTxt.charAt(u) + "</span>";

		setTimeout(changeColor, speed);
		setTimeout(newType, speed);
		
		u++;		
		
	} else {
		
		document.getElementById("body").classList.add("loaded");
		
	}

}


// Remove last 2

function typeRemove() {

	if (o < 2) {
		
		title.removeChild(title.lastElementChild);
		
		o++;
		setTimeout(typeRemove, speed);		
		
	} else {
		
		setTimeout(newType, speed);	
		
	}

}


// Type my text

function typeWriter() {
	
	if (i < txt.length) {
		
		if (window.innerWidth < 900) {
		
			if(txt.charAt(i) == " ") {
				
				title.innerHTML += "<br>";
				
			} else {
			
				title.innerHTML += "<span>" + txt.charAt(i) + "</span>";
			
			}
			
		} else {
			
			title.innerHTML += "<span>" + txt.charAt(i) + "</span>";
			
		}
		
		setTimeout(changeColor, speed);		
		
		i++;	
		
		setTimeout(typeWriter, speed);
		
	}
	
	else {
		
		setTimeout(typeRemove, speed);
		
	}
	

	
}

// Change text color

function changeColor() {
	
	let numb = title.childNodes.length;
	var colorThis = title.childNodes[numb-1];
	colorThis.classList.toggle("done");
	
}


// Background text

var count = 0;

var bg = document.getElementById("bgText");

var speed3 = 1;

var bgText;

fetch('./css/bootstrap.min.css').then(function (response) {
		
	console.log("file");
		
	return response.text();
		
}).then(function (html) {
		
		bgText = html;
		
		typeWriter2();
	
});
	


function typeWriter2() {
		
	if (count < 2000) {
		
		bg.innerHTML += bgText.charAt(count);
		
		count++;
		
		setTimeout(typeWriter2, speed3);
		
	}
}	



function canvas() {
	
	if(document.getElementById("clone").innerHTML === "") {
		document.querySelector("#clone").appendChild(document.querySelector("#bemutatkozas").cloneNode(true));
		document.querySelector("#clone").appendChild(document.querySelector("#referenciak").cloneNode(true));
		document.querySelector("#clone").appendChild(document.querySelector("#erossegek").cloneNode(true));
		document.querySelector("#clone").appendChild(document.querySelector("#elerhetosegek").cloneNode(true));
	}
	
	html2canvas(document.querySelector("#clone")).then(canvas => {
		document.body.appendChild(canvas)
		
		var img0 = canvas.toDataURL("image/jpeg");
		var png = document.createElement('a');
		png.href = img0;
		png.setAttribute("download", "download");
		png.classList.add("download_b");
		png.download = "tirk_szabolcs_cv";
		png.click();
		document.body.appendChild(png);
		
	});
}



// Document loaded

document.addEventListener('DOMContentLoaded', function () {
	
	setTimeout(function() {
		typeWriter();
	}, 1000);
	
}, false);
