<!DOCTYPE html>

<html lang="hu">

	<head>
		
		<?php 
		
			include('./header.php'); 
		
			$date = date('Y-m-d');
		?>
	
	</head>
	
	<body id="body" class="bg-dark text-white">
				
		<?php include('./navbar.php'); ?>
		
		
		<section id="banner" role="banner" class="banner d-flex align-items-center justify-content-center bg-black">
		
			<div id="bgText">
			</div>
				
			<div class="container">
			
				<h1 class="text-center text-white" id="bannerTitle"></h1>
				
			</div>

			<a href="#bemutatkozas" id="scrollNext"><span>ˇ</span></a>
			
		</section>
		
		
		<section id="bemutatkozas" class="py-5">
		
			<div class="container py-5">

				<div class="row align-items-center">
				
					<div class="col-lg-6 col-sm-12">
					
						<h2 class="h3">Bemutatkozás</h2>
						
						<p><strong>Tirk Szabolcs</strong> vagyok, <strong>5 éve</strong> foglalkozom webfejlesztéssel. Gombán élek ("Gomba" a település neve, ez sokaknak vicces). Tömegközlekedéssel szoktam utazni, ami viszont nem mindig vicces, ezért <strong>szeretek otthonról is dolgozni</strong>.</p>
						<p>Olyan csapatba szeretnék kerülni ahol tudok <strong>fejlődni</strong>. Gyorsan <strong>tanulok</strong> és ritkán fedeznek fel hibát a munkáimban. Elfogadom a <strong>kollégáim tanácsait</strong> és szeretek csapatban is dolgozni.</p>				
					
						<br>
					
						<h2 class="h3" id="tapasztalat">Tapasztalat</h2>
						
						<h3 class="h5">~5 éves ügynökségi tapasztalat</h3>
						
						<p>A legtöbb tapasztalatot <strong>Wordpress</strong> weboldalak és <strong>Woocomerce</strong> webshopok készítésében szereztem. A weboldalak nagy részét saját fejlesztésű sablonban készítettem és dolgoztam már vásárolt sablonnal is.</p>
						
						<p>Ezek mellett <strong>kampányokhoz</strong> rendszeresen készítettem HTML landinget és HTML levelet amik általában <strong>Pardotban</strong> készültek.</p>
						
					</div>
					
					<div class="col-lg-6 col-sm-12 mt-sm-5">
					
						<img src="./images/szabi_cv_illu_01.webp" alt="Illusztráció" width="1000" height="auto">
					
					</div>
				
				</div>		
				
			</div>
		
		</section>
		
		
		<section id="referenciak" class="py-5">
		
			<div class="container py-5">
								
				<h2 class="text-center mb-5 h3">Referenciák</h2>
				
				<div class="row">				
					
					<div class="col-lg-12">
					
						<h3 class="h5 mb-3">Előző munkahelyemen készített projektek:</h3>
						
						<div class="row">
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://quickmaths.hu/" title="Quick Maths"><img src="./images/ref/quickmath.svg" alt="Quick Maths" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://quickmaths.hu/" title="Quick Maths">Quick Maths</a>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://ugyfelszolgalat.profession.hu/" title="Profession Ügyfélszolgálat"><img src="./images/ref/profession.png" alt="Profession Ügyfélszolgálat" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://ugyfelszolgalat.profession.hu/" title="Profession Ügyfélszolgálat">Profession Ügyfélszolgálat</a>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://repulosepru.hu/" title="Repülő Seprű"><img src="./images/ref/repulosepru.png" alt="Repülő Seprű" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://repulosepru.hu/" title="Repülő Seprű">Repülő Seprű</a>
										</div>
									</div>											
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://puscho.hu/" title="Puscho.hu"><img src="./images/ref/puscho.png" alt="Puscho" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://puscho.hu/" title="Puscho.hu">Puscho</a>
										</div>
									</div>											
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://korforras.hu/" title="Körforrás"><img src="./images/ref/korforras.png" alt="Körforrás" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://korforras.hu/" title="Körforrás">Körforrás</a>
										</div>
									</div>											
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://ciklusfesztival.hu/" title="Ciklusfesztivál"><img src="./images/ref/ciklusfesztival.svg" alt="Ciklusfesztivál" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://ciklusfesztival.hu/" title="Ciklusfesztivál">Ciklusfesztivál</a>
										</div>
									</div>											
								</div>
							</div>
							 
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://blatox.hu/" title="Blatox"><img src="./images/ref/blatox.png" alt="Blatox" width="150" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://blatox.hu/" title="Blatox">Blatox</a>
										</div>
									</div>											
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://kurt.hu/" title="KÜRT"><img src="./images/ref/kurt.png" alt="KÜRT" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://kurt.hu/" title="KÜRT">KÜRT</a>
										</div>
									</div>											
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://seconical.hu/" title="Seconical"><img src="./images/ref/seconical.svg" alt="Seconical" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://seconical.hu/" title="Seconical">Seconical</a>
										</div>
									</div>										
								</div>
							</div>
													
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://cirus.hu/" title="Cirus Skateboards"><img src="./images/ref/cirus.svg" alt="Cirus Skateboards" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://cirus.hu/" title="Cirus Skateboards">Cirus Skateboards</a>
										</div>
									</div>									
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://mezofoldi.hu/" title="Mezőföldi Húsmanufaktúra"><img src="./images/ref/mezofoldi.svg" alt="Mezőföldi Húsmanufaktúra" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://mezofoldi.hu/" title="Mezőföldi Húsmanufaktúra">Mezőföldi Húsmanufaktúra</a>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://martisz.hu/" title="Mártisz"><img src="./images/ref/martisz.png" alt="Mártisz" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://martisz.hu/" title="Mártisz">Mártisz</a>
										</div>
									</div>
								</div>
							</div>

						
						</div>
						
					</div>
					
					<div class="col-lg-12 pt-5">
						
						<h3 class="h5 mb-3">Saját projektjeim:</h3>
						
						<div class="row">
						
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://oddish.hu/" title="Oddish"><img src="./images/ref/oddish.svg" alt="Oddish" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://oddish.hu/" title="Oddish">Oddish</a>
										</div>
									</div>
								</div>
							</div>
							
							<div class="col-lg-3 col-sm-6">
								<div class="flip-card">
									<div class="flip-card-inner">
										<div class="flip-card-front">
											<a href="https://iconxstudio.hu/" title="IconX Stúdió"><img src="./images/ref/iconx.webp" alt="IconX Stúdió" width="200" height="auto"></a>
										</div>
										<div class="flip-card-back">
											<a href="https://iconxstudio.hu/" title="IconX Stúdió">IconX Stúdió</a>
										</div>
									</div>
								</div>
							</div>

						</div>
						
					</div>					
				
				</div>		
				
			</div>
		
		</section>		


		<section id="erossegek" class="py-5">
		
			<div class="container d-flex align-items-start justify-content-center py-5">
				
				<h2 class="text-center h3">Erősségek</h2>
				
			</div>
				
			<div class="container py-5 pt-sm-0">
				
				<div class="row align-items-stretch">
				
					<div class="col-lg-4 col-sm-12 mb-sm-4">
						
						<div class="info-card text-center py-5 px-5">
								
							<h3 class="h5">Ismert nyelvek</h3>
							
							<div class="info-card-inner py-4">
							
								<ul>
								
									<li>PHP</li>
									
									<li>HTML5</li>
									
									<li>CSS3 (+Bootstrap)</li>
									
									<li>JS (JavaScript, jQuery)</li>
								
								</ul>
										
							</div>
							
						</div>
						
					</div>
				
					<div class="col-lg-4 col-sm-12 mb-sm-4">
						
						<div class="info-card text-center py-5 px-5">	
								
							<h3 class="h5">WordPress CMS</h3>
							
							<div class="info-card-inner py-4">
										
								<ul>
									
									<li>Egyedi sablon fejlesztés</li>											
									
									<li>Woocommerce, Learndash</li>
									
									<li>WPBakery, Elementor</li>
									
									<li>Polylang, WPML</li>											
									
									<li>Advanced Custom Fields</li>										
									
									<li>Yoast SEO</li>
									
									<li>Contact Form 7</li>											
									
								</ul>
										
							</div>
							
						</div>
						
					</div>
				
					<div class="col-lg-4 col-sm-12 mb-sm-4">
						
						<div class="info-card text-center py-5 px-5">						
								
							<h3 class="h5">Amit szeretek</h3>
								
							<div class="info-card-inner py-4">
								
								<ul>
									
									<li>Bemutatkozó oldal fejlesztés</li>
									
									<li>Webshop fejlesztés</li>
									
									<li>Landing fejlesztés</li>
									
									<li>HTML levél fejlesztés</li>
									
									<li>HTML email aláírás fejlesztés</li>
									
									<li>Weboldal optimalizálás</li>
									
									<li>Hibafeltárás</li>

								</ul>
								
							</div>
							
						</div>
						
					</div>
					
				</div>
				
			</div>
		
		</section>		
		
		
		<section id="elerhetosegek" class="py-5">
			
			<div class="container py-5">
			
				<h2 class="text-center mb-5 pb-3 h3">Elérhetőségek</h2>
			
				<div class="row align-items-center">			
			
					<div class="col-lg-6 col-sm-12 mb-sm-5 mb-md-0">
					
						<img src="./images/tirk_szabolcs.jpg" alt="Tirk Szabolcs" width="175" height="auto" id="profil" class="mx-auto mb-3">
					
						<h2 class="text-sm-center mb-1">Tirk Szabolcs</h2>
						
						<p class="text-sm-center mb-sm-5"><em>Webfejlesztő</em></p>
						
						<p>Születési hely, idő: <span class="text-success">Kistarcsa, 1999. 01. 14.</span></p>
						
						<p>Végzettség: <span class="text-success">Érettségi (angol nyelv, informatika), 3142/9 FEOR</span></p>
						
						<p>Email-cím: <a class="text-success" href="mailto:szabi@szabi-cv.hu">szabi@szabi-cv.hu</a></p>
						
						<p>Telefonszám: <a class="text-success" href="tel:00306676466">06 30 667 6466</a></p>
						
					</div>
				
					<div class="col-lg-6 col-sm-12">
				
						<form method="post" action="insert.php" class="form" id="rating">

							<p>Értékeld az önéletrajzom! <sup style="color: var(--bs-success);">*</sup><em class="avg d-block text-success"><?php include('./avg.php');?></em></p>
							
							<div class="rating mb-4">
							
								<input type="radio" id="rate-5" name="rate" value="5">
								<label for="rate-5">5</label>
								
								<input type="radio" id="rate-4" name="rate" value="4">
								<label for="rate-4">4</label>
								
								<input type="radio" id="rate-3" name="rate" value="3">
								<label for="rate-3">3</label>
								
								<input type="radio" id="rate-2" name="rate" value="2">
								<label for="rate-2">2</label>
								
								<input type="radio" id="rate-1" name="rate" value="1">
								<label for="rate-1">1</label>
								
							</div>
							
							<p>
								<label class="d-block" for="message">Ha van megjegyzésed az önéletrajzommal kapcsolatban, írd ide bátran!</label>
							</p>
							<p>
								<textarea id="message" name="message" placeholder="Megjegyzés" rows="5"></textarea>
							</p>
							<p style="display: none;">
								<input type="text" id="curr_date" name="curr_date" placeholder="" value="<?php echo date('Y-m-d h:i'); ?>">
							</p>							
							
							<p>
								<input id="ajaxB" type="submit" value="Megmondom a frankót!">
							</p>
							
							<p><em>A "Megmondom a frankót!" gomb megnyomásával készül egy letölthető ".zip" fájl a projektből.</em></p>
							
						</form>
						
						<div id="github" style="display: none;"><h4>Köszönöm az értékelést!</h4><p class="projekt_buttons"><a class="download" href="./szabi-cv_<?php echo $date; ?>.zip" download>Letöltöm a projektet (.zip)</a><button onclick="canvas()" id="canvas" title="Letöltöm képként (.jpg)"><span>Letöltöm képként (.jpg)</span></button></p></div>						
						
					</div>
				
				</div>
			
			</div>
		
		</section>
		
		<button onclick="goTop()" id="goTop" title="Vissza"><span>^</span></button>
		
		<?php include('./footer.php'); ?>
	
	</body>

</html>